{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:12:23 $                                        =}
{========================================================================}
unit Form_Reverb;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons,
  IniFiles,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMHTimer,
  MMEQ,
  MMDSPMtr,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMDesign,
  MMLevel,
  MMLEDS,
  MMDIBCv,
  MMSpectr,
  MMVolume,
  MMWheel,
  MMReverb,
  MMRvbDlg,
  MMEdit, MMHook, BusinessSkinForm, bsSkinCtrls;

type
  TFormReverb = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMRingBuffer1: TMMRingBuffer;
    MMWaveOut1: TMMWaveOut;
    DSPMeter: TMMDSPMeter;
    MasterVolume: TMMVolume;
    Panel4: TPanel;
    Reverb: TMMReverb;
    ReverbDialog: TMMReverbDialog;
    Panel7: TPanel;
    Bevel1: TBevel;
    lblInputGain: TLabel;
    btnSetup: TButton;
    SliderInputGain: TMMSlider;
    edInputGain: TMMNumberEdit;
    comboPreset: TComboBox;
    Bevel2: TBevel;
    Label1: TLabel;
    lblOutputGain: TLabel;
    sliderOutputGain: TMMSlider;
    edOutputGain: TMMNumberEdit;
    Bevel3: TBevel;
    lblFeedBack: TLabel;
    sliderFeedBack: TMMSlider;
    edFeedBack: TMMNumberEdit;
    Spectrum2: TMMSpectrum;
    Panel8: TPanel;
    Label4: TLabel;
    DSPLabel: TLabel;
    Label25: TLabel;
    LEDOver: TMMLED;
    Label7: TLabel;
    VolumeMaster: TMMWheel;
    btnSave: TSpeedButton;
    btnDelete: TSpeedButton;
    Skin: TbsBusinessSkinForm;
    StopBtn: TbsSkinButton;
    StartBtn: TbsSkinButton;
    MMHiTimer1: TTimer;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMWaveInStart(Sender: TObject);
    procedure MMWaveInStop(Sender: TObject);
    procedure PcmOverflow(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure btnSetupClick(Sender: TObject);
    procedure sliderChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure comboPresetChange(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure ReverbChange(Sender: TObject);
    procedure edExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    IniFile: TFileName;
  public
    procedure UpdateComboBox;
  end;

var
  FormReverb: TFormReverb;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.FormCreate(Sender: TObject);
begin
   IniFile := ExtractFilePath(Application.ExeName)+'Reverb.ini';
   UpdateComboBox;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FormReverb.FormStyle:=fsnormal;
  FormReverb.Visible:=false;
   { stop and close the device }
  MMWaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.FormShow(Sender: TObject);
begin
   { is the current device a Full-Duplex device ? }
   if not DeviceFullDuplex(MMWaveIn.DeviceID,MMWaveIn.PWaveFormat) then
   begin
      if (MMWaveIn.Mode = mStereo) then
          MessageDlg('You need a "Full-Duplex" device to run this demo'#10#13+
                     'Some older devices do not support Full-Duplex in stereo.', mtError, [mbOK], 0)
      else
          MessageDlg('You need a "Full-Duplex" device to run this demo', mtError, [mbOK], 0);

      StopBtn.Enabled := False;
      StartBtn.Enabled := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.StartBtnClick(Sender: TObject);
begin
   { open and start the device }
   MMWaveIn.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.StopBtnClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveIn.Close;

   DSPLabel.Caption := '0 %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.MMHiTimer1Timer(Sender: TObject);
begin
   DSPLabel.Caption := IntToStr(DSPMeter.Value)+ ' %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.MMWaveInStart(Sender: TObject);
begin
   MMHiTimer1.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.MMWaveInStop(Sender: TObject);
begin
   MMHiTimer1.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.PcmOverflow(Sender: TObject);
begin
   LEDOver.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.btnSetupClick(Sender: TObject);
begin
   ReverbDialog.Execute;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.UpdateComboBox;
begin
   Reverb.ReadIniSections(IniFile,comboPreset.Items);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.comboPresetChange(Sender: TObject);
begin
   Reverb.ReadFromIniFile(IniFile,comboPreset.Items[comboPreset.ItemIndex]);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.sliderChange(Sender: TObject);
begin
   edInputGain.Value := SliderInputGain.Position;
   edOutputGain.Value:= SliderOutputGain.Position;
   edFeedBack.Value  := SliderFeedBack.Position;

   Reverb.InputGain  := SliderInputGain.Position;
   Reverb.OutputGain := SliderOutputGain.Position;
   Reverb.FeedBack   := SliderFeedBack.Position;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.ReverbChange(Sender: TObject);
begin
   with Reverb do
   begin
      SliderInputGain.Position := InputGain;
      edInputGain.Value        := InputGain;

      SliderOutputGain.Position:= OutputGain;
      edOutputGain.Value       := OutputGain;

      SliderFeedBack.Position  := FeedBack;
      edFeedBack.Value         := FeedBack;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.edExit(Sender: TObject);
begin
   SliderInputGain.Position  := edInputGain.Value;
   SliderOutputGain.Position := edOutputGain.Value;
   SliderFeedBack.Position   := edFeedBack.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.btnSaveClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         if Items.IndexOf(Text) >= 0 then
            if MessageDlg('Overwrite existing preset ?', mtInformation, mbOKCancel, 0) = mrCancel then exit;

         Reverb.SaveToIniFile(IniFile,Text);
         UpdateComboBox;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormReverb.btnDeleteClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         Reverb.DeleteSection(IniFile,Text);
         Text := '';
         UpdateComboBox;
      end;
   end;
end;

end.
